<?php
class Notifications {
    private $title;
    private $message;
    private $imageUrl;
    private $action;
    private $actionDestination;
    private $data;
    private $latitude;
    private $longitude;

    public function __construct() {
        // Initialize default values if needed
    }

    public function setTitle($title) {
        $this->title = $title;
    }

    public function setMessage($message) {
        $this->message = $message;
    }

    public function setImage($imageUrl) {
        $this->imageUrl = $imageUrl;
    }

    public function setAction($action) {
        $this->action = $action;
    }

    public function setActionDestination($actionDestination) {
        $this->actionDestination = $actionDestination;
    }

    public function setPayload($data) {
        $this->data = $data;
    }

    public function setLatitude($latitude) {
        $this->latitude = $latitude;
    }

    public function setLongitude($longitude) {
        $this->longitude = $longitude;
    }

    public function getNotification() {
        $notification = array();
        if (!empty($this->title)) $notification['title'] = $this->title;
        if (!empty($this->message)) $notification['body'] = $this->message; // Use 'body' for the message in FCM
        if (!empty($this->imageUrl)) $notification['image'] = $this->imageUrl;
        if (!empty($this->action)) $notification['action'] = $this->action;
        if (!empty($this->actionDestination)) $notification['action_destination'] = $this->actionDestination;
        if (!empty($this->latitude)) $notification['latitude'] = $this->latitude;
        if (!empty($this->longitude)) $notification['longitude'] = $this->longitude;

        return $notification;
    }
}
?>
